/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.player;

import com.badlogic.gdx.math.Vector2;
import rpgboss.lib.Utils$;
import rpgboss.model.resource.RpgMapMetadata;
import rpgboss.player.CameraInfo;
import rpgboss.player.MapCameraMove;
import rpgboss.player.MutateQueue;
import rpgboss.player.entity.EntityLike;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u000f\tIQ*\u00199DC6,'/\u0019\u0006\u0003\u0007\u0011\ta\u0001\u001d7bs\u0016\u0014(\"A\u0003\u0002\u000fI\u0004xMY8tg\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0001\r\u0011\"\u0001\u0016\u0003\u0005AX#\u0001\f\u0011\u0005%9\u0012B\u0001\r\u000b\u0005\u00151En\\1u\u0011\u001dQ\u0002\u00011A\u0005\u0002m\tQ\u0001_0%KF$\"\u0001H\u0010\u0011\u0005%i\u0012B\u0001\u0010\u000b\u0005\u0011)f.\u001b;\t\u000f\u0001J\u0012\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\r\t\u0002\u0001\u0015)\u0003\u0017\u0003\tA\b\u0005C\u0004%\u0001\u0001\u0007I\u0011A\u000b\u0002\u0003eDqA\n\u0001A\u0002\u0013\u0005q%A\u0003z?\u0012*\u0017\u000f\u0006\u0002\u001dQ!9\u0001%JA\u0001\u0002\u00041\u0002B\u0002\u0016\u0001A\u0003&a#\u0001\u0002zA!9A\u0006\u0001a\u0001\n\u0003)\u0012!B:qK\u0016$\u0007b\u0002\u0018\u0001\u0001\u0004%\taL\u0001\ngB,W\rZ0%KF$\"\u0001\b\u0019\t\u000f\u0001j\u0013\u0011!a\u0001-!1!\u0007\u0001Q!\nY\taa\u001d9fK\u0012\u0004\u0003b\u0002\u001b\u0001\u0005\u0004%\t!N\u0001\n[>4X-U;fk\u0016,\u0012A\u000e\t\u0004%]\n\u0012B\u0001\u001d\u0003\u0005-iU\u000f^1uKF+X-^3\t\ri\u0002\u0001\u0015!\u00037\u0003)iwN^3Rk\u0016,X\r\t\u0005\u0006y\u0001!\t!P\u0001\u0005S:4w.F\u0001?!\t\u0011r(\u0003\u0002A\u0005\tQ1)Y7fe\u0006LeNZ8\t\u000b\t\u0003A\u0011A\"\u0002\rU\u0004H-\u0019;f)\u001daBIR)WA\nDQ!R!A\u0002Y\tQ\u0001Z3mi\u0006DQaR!A\u0002!\u000bQ\u0002\u001e:bG.,G-\u00128uSRL\bcA\u0005J\u0017&\u0011!J\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00051{U\"A'\u000b\u00059\u0013\u0011AB3oi&$\u00180\u0003\u0002Q\u001b\nQQI\u001c;jifd\u0015n[3\t\u000bI\u000b\u0005\u0019A*\u0002#\u0019|'oY3T]\u0006\u0004Hk\\#oi&$\u0018\u0010\u0005\u0002\n)&\u0011QK\u0003\u0002\b\u0005>|G.Z1o\u0011\u00159\u0016\t1\u0001Y\u0003-i\u0017\r]'fi\u0006$\u0017\r^1\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016\u0001\u0003:fg>,(oY3\u000b\u0005u#\u0011!B7pI\u0016d\u0017BA0[\u00059\u0011\u0006oZ'ba6+G/\u00193bi\u0006DQ!Y!A\u0002Y\tAb]2sK\u0016tw\u000bV5mKNDQaY!A\u0002Y\tAb]2sK\u0016t\u0007\nV5mKNDQ!\u001a\u0001\u0005\u0002\u0019\f1\"\u001a8rk\u0016,X-T8wKR!qM\u001b7o!\t\u0011\u0002.\u0003\u0002j\u0005\tiQ*\u00199DC6,'/Y'pm\u0016DQa\u001b3A\u0002Y\t!\u0001\u001a=\t\u000b5$\u0007\u0019\u0001\f\u0002\u0005\u0011L\b\"B8e\u0001\u00041\u0012\u0001\u00033ve\u0006$\u0018n\u001c8")
public class MapCamera {
    private float x = 0.0f;
    private float y = 0.0f;
    private float speed = 5.0f;
    private final MutateQueue<MapCamera> moveQueue = new MutateQueue<MapCamera>(this);

    public float x() {
        return this.x;
    }

    public void x_$eq(float x$1) {
        this.x = x$1;
    }

    public float y() {
        return this.y;
    }

    public void y_$eq(float x$1) {
        this.y = x$1;
    }

    public float speed() {
        return this.speed;
    }

    public void speed_$eq(float x$1) {
        this.speed = x$1;
    }

    public MutateQueue<MapCamera> moveQueue() {
        return this.moveQueue;
    }

    public CameraInfo info() {
        return new CameraInfo(this.x(), this.y(), this.speed(), this.moveQueue().length());
    }

    public void update(float delta, Option<EntityLike> trackedEntity, boolean forceSnapToEntity, RpgMapMetadata mapMetadata, float screenWTiles, float screenHTiles) {
        if (this.moveQueue().isEmpty()) {
            if (trackedEntity.isEmpty()) {
                return;
            }
            float desiredX = trackedEntity.get().x();
            float desiredY = trackedEntity.get().y();
            desiredX = screenWTiles >= (float)mapMetadata.xSize() ? (float)mapMetadata.xSize() / (float)2 : Utils$.MODULE$.clamped(desiredX, screenWTiles / (float)2, (float)mapMetadata.xSize() - screenWTiles / (float)2);
            desiredY = screenHTiles >= (float)mapMetadata.ySize() ? (float)mapMetadata.ySize() / (float)2 : Utils$.MODULE$.clamped(desiredY, screenHTiles / (float)2, (float)mapMetadata.ySize() - screenHTiles / (float)2);
            if (forceSnapToEntity) {
                this.x_$eq(desiredX);
                this.y_$eq(desiredY);
            } else {
                Vector2 travel = new Vector2(desiredX - this.x(), desiredY - this.y());
                travel.clamp(0.0f, delta * trackedEntity.get().speed());
                this.x_$eq(this.x() + travel.x);
                this.y_$eq(this.y() + travel.y);
            }
            return;
        }
        this.moveQueue().runQueueItem(delta);
    }

    public MapCameraMove enqueueMove(float dx, float dy, float duration) {
        Vector2 vec = new Vector2(dx, dy);
        MapCameraMove move = new MapCameraMove(vec, duration);
        this.moveQueue().enqueue(move);
        return move;
    }
}

